/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.base.helper;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import svenhjol.charm.base.enums.ICharmEnum;
import svenhjol.charm.mixin.accessor.JigsawPatternAccessor;

public class StructureHelper {
    public static Map<ResourceLocation, JigsawPattern> vanillaPools = new HashMap<ResourceLocation, JigsawPattern>();

    public static JigsawPattern getVanillaPool(ResourceLocation id) {
        if (!vanillaPools.containsKey(id)) {
            JigsawPattern pool = (JigsawPattern)WorldGenRegistries.field_243656_h.func_82594_a(id);
            List<Pair<JigsawPiece, Integer>> elementCounts = ((JigsawPatternAccessor)pool).getRawTemplates();
            ((JigsawPatternAccessor)pool).setRawTemplates(new ArrayList<Pair<JigsawPiece, Integer>>(elementCounts));
            vanillaPools.put(id, pool);
        }
        return vanillaPools.get(id);
    }

    public static void addStructurePoolElement(ResourceLocation poolId, ResourceLocation pieceId, StructureProcessorList processor, JigsawPattern.PlacementBehaviour projection, int count) {
        Pair pair = Pair.of((Object)JigsawPiece.func_242851_a((String)pieceId.toString(), (StructureProcessorList)processor), (Object)count);
        JigsawPiece element = (JigsawPiece)((Function)pair.getFirst()).apply(projection);
        JigsawPattern pool = StructureHelper.getVanillaPool(poolId);
        ((JigsawPatternAccessor)pool).getRawTemplates().add((Pair<JigsawPiece, Integer>)Pair.of((Object)element, (Object)count));
        for (int i = 0; i < count; ++i) {
            ((JigsawPatternAccessor)pool).getJigsawPieces().add(element);
        }
    }

    public static void addVillageHouse(VillageType type, ResourceLocation pieceId, int count) {
        ResourceLocation houses = new ResourceLocation("village/" + type.func_176610_l() + "/houses");
        StructureProcessorList processor = ProcessorLists.field_244107_g;
        JigsawPattern.PlacementBehaviour projection = JigsawPattern.PlacementBehaviour.RIGID;
        StructureHelper.addStructurePoolElement(houses, pieceId, processor, projection, count);
    }

    public static enum VillageType implements ICharmEnum
    {
        DESERT,
        PLAINS,
        SAVANNA,
        SNOWY,
        TAIGA;

    }
}

